;
; Preliminary (breadboard) version of parallel i/o kernel
; routines.  This version written prior to implementation
; of separate registers for parallel vs dma i/o.  When
; the real thing comes along, modify the device addresses
; in kernel.h and double check the code.
; 
; Entries :
; 		putpar - send byte out parallel interface.
; 		getpar - get byte from parallel interface.
;		getcdm - get command dma byte.
;		cdmctl - enter/exit command dma mode.
;		vmdma  - dma to/from (acc=0/1) video memory.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Send a byte to the parallel interface.;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

putpar:
	php
	sep	#0x20
	pha
;
; send the byte
;
	sta	>0,ParOut	; put the byte in parallel port
				; and set byte assembled.
	sta	>0,DevEnd	; pulse device end - interrupt host.
;
; wait for ack (any parallel byte from host)
;

$1:	lda	>0,PolDev	; data avail  (bit 7) ?
	bpl	$1		; no

	lda	>0,ParIn+1	; Get status bits in high byte of acc
	bit	#2		; no intr?
	bne	$2		; yes.. skip
	sta	>0,DevEnd	; pulse device end
$2:
	pla
	plp
	rtl


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Read one byte from the parallel interface.	;
; Generate device end if bit 2 of the high	;
; byte of the parallel data is non-zero.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

getpar:
	php
	rep	#0x20		; 16 bit mem
$1:	lda	>0,PolDev-1	; data avail  (bit 15)?
	bpl	$1		; no

	lda	>0,ParIn	; Get status bits and data.
	bit	##0x0200	; no intr?
	bne	$2		; yes.. skip
	sta	>0,DevEnd	; pulse device end
$2:
	and	##0xff		; mask off non-data bits.
	plp
	rtl

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; This routine sets up for command dma	;
; transfer on command from host.  Also	;
; it terminates this mode on command	;
; from host.  Actual enabling and 	;
; disabling of dma is done on a word by ;
; word basis in wcdma.			;
; Enter with acc 0 to disable	 	;
; command dma, <>0 to enable.		;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

cdmctl:	php
	sep	#0x20
	cmp	#0		; exit command dma mode ?
	beq	$1		; br if yes.
	lda	#8		; data flag enable.
$1:	sta	>0,DmaCtl	; enable/disable data flag.
	lda	#0		; initialize firmware flag to 
	sta	>0,Cdmsw	; indicate next cdma byte from
				; LSB of parallel port.
	plp
	rtl


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Wait for command dma byte.  Command dma input		;
; comes 2 bytes at a time.				;
; This routine requires one byte of static storage	;
; for a flag to toggle input between the low and	;
; high bytes of the input register, and one byte	;
; to save the high data byte until it is needed.	;
; NOTE - this routine should probably monitor		;
;	 host command out, and abort dma mode if it	;
;	 occurs.					;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

getcdm:
	php			; save callers m/x mode.
	sep	#0x20		; set 8 bit mem.
	
	lda	>0,Cdmsw	; time to get next word ?
	beq	$read		; branch if yes

	lda	#0		; reset 'next word flag'
	sta	>0,Cdmsw

	xba
	lda	>0,Cdmbuf+1	; get the (buffered) data byte.
	plp
	rtl

$read:
	lda	>0,PolDev+1	; command dma word avail (bit 7) ?
	bpl	$read		; branch if no, wait some more.

	sta	>0,Cdmsw	; set the 'read high byte next' flag.

	rep	#0x20
	lda	>0,CdmPrt	; get low (first) byte for caller.
	sta	>0,Cdmbuf	; stash it away.
	sta	>0,DmaEna	; raise data flag to request dma.
	and	##0xff
	plp			; restore callers m/x mode
	rtl			; and return.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Video memory DMA. This routine assumes;
; the cap control bits and drawing	;
; accelerator AOI parameters are set up.;
; Enter with acc = 0/1 for write/read.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

vmdma:
$DaDma	equ	0xff		; da dma command

	php
	sep	#0x20
	pha

	and	#1		; mask off all but r/w bit.
	ora	#$DaDma		; or in rest of da dma command.
	sta	>0,DmaCmd	; put it where Richard wants it.
	pha
	lda	#8+4		; enable data flag, external cycles.
	sta	>0,DmaCtl
	pla
;
; Start the DMA transfer by
; asserting data flag for read, or
; clearing data flag and asserting
; external cycle request for write.
;
	ror	a		; DMA read ?
	bcs	$read		; br if yes.
	sta	>0,DmaEna	; nope, assert data flag.
	bra	$1		; go wait for completion.
$read:	sta	>0,DmaDsb	; remove data flag, assert ext cyc req.
$1:

;
; Wait for host command out
; to signal transfer complete.
;
	lda	>0,PolDev	; cmd out is in bit 7
	bpl	$1		; br if no cmd out yet.
;
; Disable data flag, external cycle requests.
; Disabling also clears these signals.
;
	lda	#0
	sta	>0,DmaCtl	; disable data flag, ext cycle req.
;
; Acknowledge command out with device end intrpt.
;
	sta	>0,DevEnd

	pla
	plp
	rtl
cdmend:
	end
